# 📚 TODO

## ⬛ Blacklists

- [Exodus Privacy](https://reports.exodus-privacy.eu.org/en/)
- [Mochi Filter](https://github.com/eEIi0A5L/adblock_filter/blob/master/mochi_filter.txt)
- [migueldemoura](https://github.com/migueldemoura/ublock-umatrix-rulesets)
- nextdns
  - [cname-cloaking-blocklist](https://github.com/nextdns/cname-cloaking-blocklist) ?
- [uAssets](https://github.com/uBlockOrigin/uAssets)
- [pop3gropers](https://home.nuug.no/~peter/pop3gropers.txt)
- [blacklist-named](https://github.com/tomzuu/blacklist-named)
- [ad-wars](https://github.com/jdlingyu/ad-wars)
- [turk-adlist](https://github.com/bkrucarci/turk-adlist)
- [ad-hosts](https://github.com/ilpl/ad-hosts)
- [SNAFU](https://github.com/RooneyMcNibNug/pihole-stuff/blob/master/SNAFU.txt)
- [dohservers](https://github.com/oneoffdallas/dohservers)
- [DroneBL](https://dronebl.org/docs/howtouse) ?
- [Free Email Provider Domains](https://gist.github.com/tbrianjones/5992856)
- [Search Engine Spam Blocklist](https://github.com/no-cmyk/Search-Engine-Spam-Blocklist)
- [anti-axelspringer-hosts](https://github.com/autinerd/anti-axelspringer-hosts#anti-axel-springer-hosts-file)
- [wh0ami](https://codeberg.org/wh0ami/pihole-lists)
- [Artists Against 419](https://db.aa419.org/fakebankslist.php)
- [Okean Spam ChinaCIDR](https://www.okean.com/chinacidr.txt)
- [perso](https://perso.pw/blocklist.txt)
- [Lunar Blocklist](https://blocklist.palemoon.org/ABL/lunar-blocklist.txt)
- [Luke's Blocklist](https://github.com/lwojcik/lukes-pihole-blocklist)
- [Ugly Email Trackers](https://github.com/OneClickLab/ugly-email-trackers)
  - [Leave Me Alone](https://github.com/leavemealone-app/email-trackers)
- [mhhakim](https://github.com/mhhakim/pihole-blocklist)
  - custom-blacklist
  - custom-porn-blacklist
- [TR-CERT](https://www.usom.gov.tr/url-list.txt)
  - Reference: [usom-blacklist](https://github.com/fuatboluk/usom-blacklist)
- [bestpika](https://github.com/bestpika/abp)
  - cf
  - hosts
  - yui
- [cjxlist](https://github.com/cjx82630/cjxlist)
  - cjx-annoyance
  - cjx-ublock ?
  - cjxlist
- [YousList](https://github.com/yous/YousList)
- [xiaobeita](https://github.com/rentianyu/Ad-set-hosts/tree/master/xiaobeita)
- [VeleSila/yhosts](https://github.com/VeleSila/yhosts)
- [ilpl](https://github.com/ilpl/ad-hosts)
- [Cats-Team](https://github.com/Cats-Team/AdRules)
  - [Mirror](https://cats-team.coding.net/p/adguard/d/AdRules/git/raw/main/ad-domains.txt)
- [XIU2](https://github.com/XIU2/TrackersListCollection)
  - blacklist
- [blockconvert](https://github.com/mkb2091/blockconvert)
  - [blocklist](https://github.com/mkb2091/blockconvert/blob/master/internal/blocklist.txt)
- [CleanTalk](https://cleantalk.org/help/iptables-connect)
- [UA Blocklist](https://blocklist.net.ua/providers/)
- [BotScout](https://botscout.com/last_caught_cache.htm)
- [unflac](https://github.com/unflac/filter/blob/main/filter.txt)
- [SukkaW](https://github.com/SukkaW/Surge/blob/master/List/non_ip/my_reject.conf)
- [xOS](https://github.com/xOS/Config/blob/Her/RuleSet/Advertising.list)
- [i-blocklist](https://github.com/jackrabbit335/UsefulLinuxShellScripts/blob/master/blocklist-update.sh#L17)
- [disposable-email-domains](https://github.com/ivolo/disposable-email-domains/blob/master/index.json)
- [Cyjax Uploads](https://www.cyjax.com/latest-analysis/)
- [Discord Phishing Links](https://github.com/nikolaischunk/discord-phishing-links)
- [YT Spam Lists](https://github.com/ThioJoe/YT-Spam-Lists/blob/main/SpamDomainsList.txt)

## Add but archive

- [Quarklist](https://github.com/francis-zhao/quarklist)
- [Cameleon](https://sysctl.org/cameleon/)
- [BadHosts](https://www.hostsfile.org/hosts.html)
- [brijrajparmar27](https://raw.githubusercontent.com/brijrajparmar27/host-sources/master/Porn/hosts)

## ⬜ Whitelists

*Add more here!*

# 🥢 Duplicates

> Sources that contain duplicate and potentially deprecated data.

- [andryou](https://gitlab.com/andryou/block#sources)
- [adfree](https://adfree-hosts.odiousapps.com/adfree.php)
  - Save as "adfree.gz," and run "gunzip adfree.gz"
- [canihazprivacy](https://canihazprivacy.com/)
- [ftpmorph pastebin](https://pastebin.com/raw/gKaWxety)
- [my](https://github.com/mypdns/matrix)[pdns](https://mypdns.org/mypdns/support/-/wikis/Blacklists/Abusech-badips)
- [gnuzilla](https://gnuzilla.gnu.org/filters/)
  - In [`update.sh`](https://gnuzilla.gnu.org/filters/retriever/update.sh):
    ```bash
    wget https://easylist-downloads.adblockplus.org/easyprivacy.txt -q
    wget https://easylist-downloads.adblockplus.org/easylist.txt -q
    #wget https://easylist-downloads.adblockplus.org/antiadblockfilters.txt -q
    #wget https://easylist-downloads.adblockplus.org/fanboy-annoyance.txt -q
    wget https://easylist-downloads.adblockplus.org/fanboy-social.txt -q
    ```
- [sebsauvage](https://sebsauvage.net/hosts/hosts)
- [EmergingThreats](https://rules.emergingthreats.net/blockrules/)
  - Pulls from abuse.ch, spamhaus, and dshield, which are all in use.
- [mobile-hosts](https://github.com/r-a-y/mobile-hosts)
- [potentialTrackers](https://github.com/jawz101/potentialTrackers)
- [UsefulLinuxShellScripts](https://github.com/jackrabbit335/UsefulLinuxShellScripts)
  - Active but references sources from iBlocklist.
- [hosts.extra](https://github.com/FadeMind/hosts.extras#extra-rules-for-steven-blacks-hosts-project)
- [blackbook](https://github.com/stamparm/blackbook)
- [mischosts](https://github.com/llacb47/mischosts)
  - Only TikTok list; WhiteOps is should be double-checked.
- [ut-capitole](https://dsi.ut-capitole.fr/blacklists/index_en.php)
  - Has a lot of deprecated data.
- [shallalist](https://www.shallalist.de/)
  - Similar to `ut-capitole`.
  - [cbuijs](https://github.com/cbuijs/shallalist)
- [malware-filter](https://gitlab.com/curben/malware-filter)
- [AdlistTXTS](https://github.com/CleanMachine1/AdlistTXTS#readme)
- [socialblocklists](https://github.com/d43m0nhLInt3r/socialblocklists#readme)
- [Bon-Appetit](https://github.com/Bon-Appetit/porn-domains)
  - [alexsannikov](https://github.com/alexsannikov/adguardhome-filters) [(?)](https://github.com/pq6p41fgt6k/potential-octo-parakeet)
  - [CastleAds](https://github.com/Castle67/CastleAds)
  - [emiliodallatorre](https://github.com/emiliodallatorre/adult-hosts-list)
  - [foopsss](https://github.com/foopsss/hosts)
  - [go2engineering](https://github.com/go2engineering/pihole-blocklists)
- [stevejenkins](https://github.com/stevejenkins/my-pihole-lists)
- [ftprivacy](https://github.com/ftpmorph/ftprivacy)
- [sophos-xg-block-lists](https://github.com/austinheap/sophos-xg-block-lists)
- [justdomains](https://github.com/justdomains/blocklists)
- [blockconvert](https://github.com/mkb2091/blockconvert/blob/master/filterlists.csv)
- [neodevhost](https://github.com/neodevpro/neodevhost)
- [ookangzheng](https://github.com/ookangzheng/dbl-oisd-nl)
  - OISD mirroring project.
- [smashblock](https://github.com/smashah/smashblock)
- [hblock](https://github.com/hectorm/hblock/blob/master/SOURCES.md)
- [hl2guide](https://raw.githubusercontent.com/hl2guide/Filterlist-for-AdGuard-or-PiHole/master/filter_list_URLs.txt)
- [dns-blocklists](https://github.com/hagezi/dns-blocklists)
- [hemiipatu](https://github.com/hemiipatu/PiHoleBlocklists/tree/master/blocklists)
- [1024_hosts](https://github.com/Goooler/1024_hosts)
- [MiscellaneousFactory](https://github.com/MiscellaneousFactory/AdBlockList/blob/master/autocheck.sh)
- [rentianyu](https://github.com/rentianyu/Ad-set-hosts/blob/master/update.sh)
- [GitHub520](https://github.com/521xueweihan/GitHub520)
- [Matty Roberts Threat List](https://www.matthewroberts.io/threatlist.html)
  - Used lists [here](https://github.com/bluerogue/threatlist/blob/master/src/main/java/io/matthewroberts/threatlist/service/ThreatAggregationServiceImpl.java#L32).
- [StrictBlockPAllebone](https://github.com/pallebone/StrictBlockPAllebone)
- [mullvad](https://github.com/mullvad/dns-blocklists)
- [notracking](https://github.com/notracking/hosts-blocklists/blob/master/SOURCES.md)
- [aminurrashid](http://www.aminurrashid.com/files/hosts.txt)
  - Ancient `WinHelp` version.
- [abuseme](https://abuseme.nl/)
  - Project Honey Pot contributors, so some data is likely duplicated.
- [AmmoniteFilter](https://ammnt.app/)
  - Optimized for use with AdGuard.
  - Likely covered by other anti cryptoscam and adult content blacklists.
- [anal.fi](https://anal.fi/tracking_by_privacychoice_org.txt)
  - Modern trackers are covered by other lists.
- [amirtorrez](https://gitlab.com/amirtorrez)
  - Mirrord ancient list content.
- [fanboy-adblock](https://github.com/ryanbr/fanboy-adblock)
  - The EnhancedStats Addon is the only active list.
- [chipcun](http://chipcun.dynu.com:8080/Upload/47adblock.txt)
  - Ancient `hostsVN` version.
- [davidc](http://davidc.theunixplace.com/list.txt)
  - Last-Modified: Tue, 10 Apr 2007 05:46:21 GMT
  - Appears to be an ancient `WinHelp` version.
- Dinis's old RU adlists
  - [Adblock](http://denis-ovs.narod.ru/adblock.txt)
  - [Hosts](https://dinis.ru/files/hosts)
- [hessowan](https://hessowan.prv.pl/blo.txt)
  - Last-Modified: Fri, 05 Feb 2016 17:00:54 GMT
  - Ancient `AdAway` version.
- [labalec](https://labalec.fr/erwan/wp-content/uploads/2013/12/denied_domains.txt)
  - Ancient `yoyo` version.
- [idannywu](https://www.idannywu.com//dannywugooglehosts/hosts.txt)
  - [SY618](https://github.com/SY618)
  - References a `yhosts` predecessor.
  - [kelthuzadx](https://github.com/kelthuzadx/hosts)
- [Naked Browser Pro](http://nakedbrowser.com/pro/.nbhosts.txt)
  - Ancient `EasyList` version.
- [stanev](https://stanev.org/abp/adblock_bg.txt)
  - Guessing this is a 2021 `EasyList` version.
- [stascorp](https://stascorp.com/hosts.txt)
  - Last-Modified: Wed, 07 Apr 2010 14:48:19 GMT
- [szojox](http://szojox.ugu.pl/hosts)
  - Ancient `WinHelp` + `yoyo` versions
- [torben](https://torben.g-b.dk/wp-content/uploads/2015/03/hosts.txt)
  - Ancient `WinHelp` + `yoyo` versions
- [lansystem](https://www.lansystem.com.br/util01/hosts)
  - Ancient `WinHelp` version.
- [mostonet](http://www.mostonet.it/upd/win/hostslv3.new)
  - Actively updated though!
- [sspakrac](https://www.sspakrac.hr/blokiraniurl/hosts.txt)
  - Ancient `WinHelp` version.
- [quindecim blocklist](https://github.com/quindecim/block/)

# 🧟 Zombies

> Sources that are dead or deprecated and not included but may be [worth mentioning](https://blog.talosintelligence.com/2021/03/domain-dumpster-diving.html).

- [Squidguard Archive](http://squidguard.mesd.k12.or.us/)
  - Found individually a while back
  - Contains some obvious placeholder/garbage domains
- [BarbBlock](https://github.com/paulgb/BarbBlock/blob/master/blacklists/domain-list.txt)
- [NSABlocklist](https://github.com/nextdns/metadata/blob/master/privacy/blocklists/nsa-blocklist.json)
- [Wael](https://www.wael.name/other/best-blocklist/)
- [Sblam](https://github.com/kornelski/Sblam/tree/master/data)
- [St. Dominic's Priory College](https://www.stdominics.sa.edu.au/) [Droplists](https://threatintel.stdominics.sa.edu.au/)
- [URLVir](https://www.urlvir.com/)
- [unit42](https://github.com/pan-unit42/iocs)
  - Select `Go to file`, then search using the term "domains"
- [fireeye](https://github.com/fireeye/iocs)
- [aptnotes](https://github.com/aptnotes/data#how-is-this-data-being-utilized)
- [malware-indicators](https://github.com/citizenlab/malware-indicators)
- [da667](https://github.com/da667/667s_Shitlist)
- [malware-ioc](https://github.com/eset/malware-ioc)
- [malwaredomains](http://malwaredomains.lehigh.edu/files/)
- [multiproxy](https://multiproxy.org/)
- [malwaredomainlist](http://www.malwaredomainlist.com/)
- [malware-traffic-analysis](https://www.malware-traffic-analysis.net/index.html)
- [nothink](https://www.nothink.org/)
- [targetedthreats](https://github.com/botherder/targetedthreats/)
- [policeman-rulesets](https://github.com/futpib/policeman-rulesets/)
- [malwaremustdie](https://malwared.malwaremustdie.org/)
- [threatfeeds](https://threatfeeds.io/)
  - Some HTTP-200 sources updated a long time ago
- [yourcmc](http://vmx.yourcmc.ru/BAD_HOSTS.IP4)
  - `Last-Modified: Wed, 04 Jul 2012 21:04:35 GMT`
- [iblocklist](https://www.iblocklist.com/lists)
- [malc0de](http://malc0de.com/bl/)
  - **_MALC0DE'S RSS FEED CONTAINS SHADE RANSOMWARE! YOU HAVE BEEN WARNED._**
- [malfeed](https://github.com/eSentire/malfeed/)
- [carl.net](https://carl.net/spam/access.txt)
  - `last-modified: Sun, 01 Sep 2002 16:05:00 GMT`
- [gjtech](https://web.archive.org/web/20160221135711/http://adblock.gjtech.net/?format=unix-hosts)
- [ethanr dns-blacklists](https://bitbucket.org/ethanr/dns-blacklists/src/master/bad_lists/)
- [keweonDNS](https://forum.xda-developers.com/t/keweondns-now-with-improved-certificate-ios-mac-android.3681139/) [up2date](https://pastebin.com/raw/UP3s7pEB)
- [deathbybandaid](https://github.com/deathbybandaid/piholeparser/tree/master/Subscribable-Lists/ParsedBlacklists)
- [Ransomware Overview](https://docs.google.com/spreadsheets/u/1/d/1TWS238xacAto-fLKh1n5uTsdijWdCEsGIM0Y0Hvmc5g/pubhtml#)
- fanboy
  - [vietnam](https://fanboy.co.nz/fanboy-vietnam.txt)
  - [japanese](https://fanboy.co.nz/fanboy-japanese.txt)
  - [polish](https://fanboy.co.nz/fanboy-polish.txt)
- [ryanbr](https://github.com/ryanbr/fanboy-adblock)
- [Princeton Webcensus](https://webtransparency.cs.princeton.edu/webcensus/)
- [UnrealSecurity](https://github.com/UnrealSecurity/badips)
  - Takes too long to respond; likely offline.
- [ipspamlist](http://www.ipspamlist.com/)
  - Last updated in 2020.
- [neohosts](https://github.com/neoFelhz/neohosts)
- [android-stalkerware](https://github.com/diskurse/android-stalkerware)
- [stalkerware-urls](https://github.com/astryzia/stalkerware-urls)
  - Presently archived.
- [h3x](https://tracker.h3x.eu/)
  - Feeds are empty.
- [Minimal-Hosts-Blocker](https://github.com/arcetera/Minimal-Hosts-Blocker)
- [piholeparser](https://github.com/deathbybandaid/piholeparser)
- [IsraelList](https://jansal.net/tpl/IsraelList.tpl)
- [niecko](https://www.niecko.pl/adblock/adblock.txt)
- [DontPushMe](https://github.com/caffeinewriter/DontPushMe)
- [pfbng](https://github.com/angelics/pfbng)
- [NanoFilters](https://github.com/NanoAdblocker/NanoFilters)
- [dnsbl-dfed](https://github.com/dfederlein/dnsbl-dfed)
- [nopelist](https://github.com/genediazjr/nopelist)
- DisconnectMe AWS
  - [simple_ad](https://s3.amazonaws.com/lists.disconnect.me/simple_ad.txt) (Last-Modified: Fri, 31 Jul 2015 19:01:02 GMT)
  - [simple_tracking](https://s3.amazonaws.com/lists.disconnect.me/simple_tracking.txt) (Last-Modified: Sat, 01 Feb 2020 02:37:09 GMT)
  - [shavar-prod-lists](https://github.com/mozilla-services/shavar-prod-lists)
- [phishing_hosts](https://github.com/Kurobeats/phishing_hosts)
- [antipopads](https://github.com/Yhonay/antipopads)
- [romanian-media-propaganda-adblock-list](https://github.com/Recon/romanian-media-propaganda-adblock-list)
- [cosmonotes](https://cosmonote.blogspot.com/2013/09/Download.html)
  - Mediafire links are still good.
- [Gift-Card-Killer](https://github.com/TakoYachty/Gift-Card-Killer)
- [crypto-scams-fr](https://github.com/CryptoFR/crypto-scams-fr)
- [GetAdmiral](https://github.com/smed79/blacklist)
- [spammerslapper](http://spammerslapper.com/downloads/adblock_include.conf)
- [Badd-Boyz-Hosts](https://github.com/mitchellkrogza/Badd-Boyz-Hosts)
- [The-Big-List-of-Hacked-Malware-Web-Sites](https://github.com/mitchellkrogza/The-Big-List-of-Hacked-Malware-Web-Sites)
- [AdmiraList](https://github.com/jkrejcha/AdmiraList)
- [dns-zone-blacklist](https://github.com/oznu/dns-zone-blacklist)
- [List-KR](https://github.com/slang1998/List-KR)
- [uBlock-Filters-Plus](https://github.com/IDKwhattoputhere/uBlock-Filters-Plus)
- [uBOPa](https://github.com/nimasaj/uBOPa)
- [iploggerfilter](https://github.com/piperun/iploggerfilter)
- [thai-ads-filter](https://github.com/adblock-thai/thai-ads-filter)
- [Cryptojacking-campaign-list](https://github.com/deHakkelaar/Cryptojacking-campaign-list)
  - Active but draws from inactive Google Sheets.
  - <https://dehakkelaar.nl/lists/>
- [yhosts](https://github.com/vokins/yhosts)
- [easylistczechandslovak](https://github.com/tomasko126/easylistczechandslovak)
- [Andrew's Settings](https://gitlab.com/andryou/andrews-settings#andrews-settings-and-config-files)
- [dupontjean](https://github.com/dupontjean/pihole-blocklist#pihole-blocklist)
- [jmdugan](https://github.com/jmdugan/blocklists)
- [void-gr-filters](https://www.void.gr/kargig/void-gr-filters.txt)
- [pdns-recreator](https://github.com/suuhm/pdns-recreator)
- [adblock.gardar](https://adblock.gardar.net/)
- [TR-PhishingList](https://github.com/HorusTeknoloji/TR-PhishingList)
- [bgpranking](https://github.com/D4-project/BGP-Ranking/tree/master/bgpranking/config/modules)
- [anti-pr0n](https://github.com/CyanideBrother/anti-pr0n)
- [Evil Domains](https://github.com/hell-sh/Evil-Domains/tree/master/lists)
- [AdBlock Rules](https://bitbucket.org/nicktabick/adblock-rules/src/master/)
- [Clickbait Blocklist](https://github.com/cpeterso/clickbait-blocklist)
- [Hello, Goodbye](https://github.com/bcye/Hello-Goodbye)
- [0131 blocklist](https://github.com/austinhuang0131/0131-block-list)
- [international-list](https://github.com/betterwebleon/international-list)
- [nothingblock](https://github.com/sayomelu/nothingblock)
- [Andromeda uBlock](https://github.com/hit3shjain/Andromeda-ublock-list)
- [uBlock Filters Plus](https://github.com/IDKwhattoputhere/uBlock-Filters-Plus)
- [I don't care about cookies](https://www.i-dont-care-about-cookies.eu/abp/)
- [Netlab's Mirai Scanner](https://data.netlab.360.com/mirai-scanner/)
- [cyberthreat](https://www.cyberthreatcoalition.org/blocklist)
  - Service has ended.
- [Haruko](https://tracker.fumik0.com/)
  - Offline since last check.
- [Clefspeare13](https://tinyurl.com/clefspeare13)
  - [GitHub's Dirty Dancing](https://github.com/StevenBlack/hosts/pull/1784)
- [Zonefiles](https://zonefiles.io/compromised-ip-list/)
  - Offline since last check.
- [black-domains](https://github.com/ADsecu/black-domains)
- [ADios!](https://github.com/AlexRabbit/ADios)
- [Amdr0meda](https://github.com/Amdr0meda/Blocklist_Pi_Hole)
- [BlockNews](https://github.com/MarByteBeep/BlockNews)
- PiHole Regex
  - [mmotti](https://github.com/mmotti/pihole-regex)
  - [PebbleOG](https://github.com/PebbleOG/pihole-regex)
  - [revolveruk30](https://github.com/revolveruk30/pihole-regex)
- [Phentora](https://github.com/Phentora/AdguardPersonalList)
- [SteamScamSites](https://github.com/PoorPocketsMcNewHold/SteamScamSites)
- [fakerando-domains](https://github.com/SoftCreatR/fakerando-domains)
- [teleme7ry](https://github.com/Strappazzon/teleme7ry)
- [XionKzn](https://github.com/XionKzn/PiHole-Lists)
  - Needs more investigation
- [youtubeadsblacklist](https://github.com/anudeepND/youtubeadsblacklist)
- [Bon-Appetit](https://github.com/Bon-Appetit/porn-domains)
  - [brijrajparmar27](https://github.com/brijrajparmar27/host-sources)
  - [EdmondN1](https://github.com/EdmondN1/MyPiHoleLists)
  - [bad-websites](https://github.com/elbkr/bad-websites)
  - [moose84](https://github.com/moose84/list)
  - [nizekun](https://github.com/nizekun/adguardhome-blocklist)
  - [PedroJuan91](https://github.com/PedroJuan91/porn-list)
- [TonyRL](https://github.com/TonyRL/blocklist)
- [pfbng](https://github.com/angelics/pfbng)
- [anthony-wang](https://github.com/anthony-wang/PiHoleBlocklist)
- [CB-Malicious-Domains](https://github.com/cb-software/CB-Malicious-Domains)
- [cloudsvrtech](https://github.com/cloudsvrtech?tab=repositories)
  - [pfsense_porn_famous](https://github.com/cloudsvrtech/pfsense_porn_famous)
  - [pfsense_ips_custom_blocklist](https://github.com/cloudsvrtech/pfsense_ips_custom_blocklist)
  - [pfsense_ips_youtube](https://github.com/cloudsvrtech/pfsense_ips_youtube)
  - [pfsense_ips_instagram](https://github.com/cloudsvrtech/pfsense_ips_instagram)
  - [pfsense_ips_facebook](https://github.com/cloudsvrtech/pfsense_ips_facebook)
  - [pfsense_ips_miscSocialMedia](https://github.com/cloudsvrtech/pfsense_ips_miscSocialMedia)
- [ProtectorHosts](https://github.com/furkun/ProtectorHosts)
- [adblock-nsa](https://github.com/gasull/adblock-nsa)
- [magento-malware-scanner](https://github.com/gwillem/magento-malware-scanner)
- [gyli](https://github.com/gyli/Blocklist)
- [kboghdady](https://github.com/kboghdady/youTube_ads_4_pi-hole)
- [covid-domains](https://github.com/merkleID/covid-domains)
- [semalt-blocker](https://github.com/nabble/semalt-blocker)
- nextdns
  - [piracy-blocklists](https://github.com/nextdns/piracy-blocklists)
- [LeeCh-List](https://github.com/pureexe/LeeCh-List)
- [antifa-n](https://github.com/antifa-n/pihole)
- [phased-array](https://github.com/rto/phased-array)
- [fluffy-blocklist](https://github.com/sk-cat/fluffy-blocklist)
- [covid-iocs](https://github.com/sophoslabs/covid-iocs)
- [twcau](https://github.com/twcau/AdblockRules)
- [AdblockListABP](https://github.com/w13d/adblockListABP-PiHole)
- [xlimit91](https://github.com/xlimit91/xlimit91-block-list)
- [china-cdn-domain-whitelist](https://github.com/mawenjian/china-cdn-domain-whitelist)
- [TheGreatWall](https://github.com/Sekhan/TheGreatWall)
- [Flyn Computing](https://www.flyn.org/CDX/2017-dns-blacklist.txt)
- [appelboor](https://www.appelboor.com/dump/)
- [blocklist.googlepages](https://sites.google.com/site/blocklist/)
- [Prebake](https://github.com/liamja/Prebake)
- [IDKwhattoputhere](https://github.com/IDKwhattoputhere/uBlock-Filters-Plus)
- [lumeninterius](https://s3.amazonaws.com/www.lumeninterius.com/ublocklist/blocklist.txt)
  - Last-Modified: Wed, 14 Jun 2017 00:51:26 GMT
- [technoy](https://www.technoy.de/lists/blocklist.txt)
- [FMSF 2](https://nmtrung.com/fmsf-2/)
- [NoAdDNS](https://noaddns.com/)
  - The list link just downloads the update script.
- [wolfsrealm](https://github.com/wolfsrealm/AdBlockLists)
- [FearrMe](https://github.com/FearrMe/pihole)
- [ElCap1tan](https://github.com/ElCap1tan/PiHole-Parsed-Filter-Lists)
- [GATmyIT](https://github.com/GATmyIT/pihole-lists)
- [Rafaelrico77](https://github.com/Rafaelrico77/piholeyt)
- [imkarthikk](https://github.com/imkarthikk/pihole-facebook)
- [BlockYouX](https://ceadd.ca/blockyoux.txt)
- [BlockWindows](https://github.com/WindowsLies/BlockWindows)
- [hpthreatresearch](https://github.com/hpthreatresearch/iocs)
- [murdoch_blocklist](https://github.com/suodrazah/murdoch_blocklist)
- pirat28
  - [IHateTracker](https://github.com/pirat28/IHateTracker)
  - [IHateSPAMList](https://github.com/pirat28/IHateSPAMList)
  - [IHateURLshort](https://github.com/pirat28/IHateURLshort)
- [labs_campaigns](https://github.com/guardicore/labs_campaigns)
- [KitsapCreator](https://github.com/KitsapCreator/pihole-blocklists)
- [uBlockProtector](https://github.com/jspenguin2017/uBlockProtector)
- [tekintian](https://github.com/tekintian/hosts_ads_block)
- [E7KMbb](https://github.com/E7KMbb/AD-hosts/tree/master/system/etc)
- [blackhosts](https://github.com/easonjim/blackhosts)
- [Licolnlee](https://github.com/Licolnlee/AdBlockList)
- [Amazefcc233](https://github.com/Amazefcc233/no-ads-hosts)
- [extstars](https://files.extstars.com/hosts/)
- [4in6](http://www.4in6.net/legacy/AdBlock.txt)
  - Last-Modified: Fri, 30 Oct 2020 22:09:46 GMT
  - [Threatfeeds](https://threatfeeds.4in6.net/api/deleteme?list=doorknockers)
- [threatsourcing](https://www.threatsourcing.com/)
  - dnall-free
  - ipall-free
- [coinhive-block](https://github.com/Marfjeh/coinhive-block)
- [AnotherUnifiedBlockList](https://github.com/songxiaosen/AnotherUnifiedBlockList)
- [threatcrowd](https://threatcrowd.org/)
  - Behind the Great Cloudwall
  - [domains](https://threatcrowd.org/feeds/domains.txt)
  - [ips](https://threatcrowd.org/feeds/ips.txt)
  - [blacklist](https://threatcrowd.org/inc/blacklist.txt)
- [360_netlab](https://data.netlab.360.com/)
  - Pay-walled
- [kriskintel](https://kriskintel.com/)
  - Bad TLS configuration
- [Cybo1927](https://github.com/Cybo1927/Hosts)
- [Energized Xtreme Extension](https://github.com/EnergizedProtection/block#extensions-2)
- [joewein's domain lists](https://joewein.net/spam/bl-text.htm)
  - The domain lists have been deprecated.
- [youtube_ad_blocklist](https://github.com/Ewpratten/youtube_ad_blocklist)
- [Airelle's Hosts](http://rlwpx.free.fr/WPFF/hosts.htm)
  - The content of every download has their "NoWar" package, which includes scripts intented to DDoS Russian websites.
- [interactivefriends](http://interactivefriends.co.uk/blocklist.txt)
  - Seems to be against gambling.
- [Yuki's Old Adblock](https://github.com/Yuki2718/adblock)
- [accs-net](http://accs-net.com/hosts/get_hosts.html)
- [abp-japanese-filters](https://github.com/k2jp/abp-japanese-filters)
- [nb-m.de](http://nb-m.de/cybercrime/blacklists.txt)
- [ThirtyThousandList](https://aliyun-static.oss-cn-beijing.aliyuncs.com/Proxy/ThirtyThousandList.Conf)
  - Last-Modified: Thu, 19 May 2016 14:41:49 GMT
- [amigas](http://amigas.ru/~vadim/)
- [unbelovedhosts](https://apk.defim.de/app/unbelovedhosts/hosts.txt)
  - Last-Modified: Thu, 01 Feb 2018 21:16:17 GMT
  - APK thread has been removed from XDA forums.
- [tomalaplaza](https://15hack.tomalaplaza.net/files/aede.txt)
  - Last-Modified: Sat, 25 Apr 2020 17:10:02 GMT
  - [End of Services Notice on homepage](https://15hack.tomalaplaza.net/).
- [280blocker](https://280blocker.net/download/)
  - All lists available are empty.
- [thai-ads-filters](https://github.com/adblock-thai/thai-ads-filter#thai-ads-filters)
- [NixNet DNS](https://docs.nixnet.services/NixNet_DNS)
- [Henrik Schack](https://adblock.dk/block.csv)
  - Last-Modified: Wed, 13 Jun 2018 05:57:12 GMT
  - Not in a CSV format.
- [adren](https://adren.org/~cyril/)
- [dcod](https://agh.lite.dcod.ml/hosts.php)
  - Currently inaccessible due to a SSL_ERROR_RX_RECORD_TOO_LONG error.
- [PornAway](https://github.com/mhxion/pornaway#readme)
- [anonymousposter](https://anonymousposter.gitlab.io/ublockorigin-rules/blockrules.txt)
  - Unable to check due to GitLab's content restriction.
- [antyblokada](https://antyblokada.pl/)
  - Last updated in 2019.
- [babin](http://babin.nelly.free.fr/wwblock.ini)
  - Last-Modified: Sun, 05 Jun 2005 20:47:25 GMT
- [abp-japanese-filters](https://github.com/k2jp/abp-japanese-filters)
- blacklists.cert.gov.ge
  - Takes too long to respond.
- [d3d](https://blog.d3d.org/ads_block_d3d_lite.txt)
- [goods-pro](http://blog.goods-pro.com/wp-uploads/2008/08/hosts.txt)
- [lxx1](https://www.lxx1.com/wp-content/uploads/2016/03/hosts.txt)
- daum attachments
  - [2543873E51C5263237BC28](http://cfile215.uf.daum.net/attach/2543873E51C5263237BC28)
- tistory attachments
  - [999DAC3A5B49FF62155599](http://cfile23.uf.tistory.com/attach/999DAC3A5B49FF62155599)
  - [261EED485142BA5C2283D1](http://cfile25.uf.tistory.com/attach/261EED485142BA5C2283D1)
- [chitta001](https://chitta001.cocolog-nifty.com/blog/files/host.txt)
  - Last-Modified: Mon, 12 Mar 2018 13:43:03 GMT
- [cyberside](https://cyberside.net.ee/adblock/)
  - [ibiblio](https://www.ibiblio.org/pub/micro/pc-stuff/freedos/)
- [marcofolio](https://downloads.marcofolio.net/useful/tips/block/hosts.txt)
- [orbitum](https://extupdate.orbitum.com/adblock/ad_servers.txt)
  - Last-Modified: Mon, 24 Oct 2016 13:29:47 GMT
  - Appears to have a modern app that may have active lists somewhere.
  - <https://orbitum.com/>
- [fblan](http://fblan.de/postfix/hosts.txt)
  - Last-Modified: Fri, 14 Dec 2012 21:49:00 GMT
- [easytimetv](http://file1.easytimetv.com/out_Adblock.conf)
  - Last-Modified: Sat, 23 Jan 2016 19:49:53 GMT
  - Maintains extensive headers that may be subject to manipulation.
  - Perhaps associated with [EasytimeTV](https://github.com/EasytimeTV)?
- [bestmail](https://files.bestmail.ws/hosts.txt)
  - Last-Modified: Sat, 26 Nov 2011 01:00:00 GMT
  - [Homepage](https://www.bestmail.ws/)
- [Dawsey21](https://github.com/Dawsey21/Lists)
  - The precursor to Spam404.
- [adhell](https://github.com/adhell/adhell.github.io)
- [getlives](https://getlives.com/files/hosts.txt)
  - Encourge the Twitch Streamer to bring it back?
  - <https://www.twitch.tv/syrsly>
- [ayucat](http://git.sourceforge.jp/view?p=ayucat-list/ayucat-list.git;a=blob_plain;f=ayucat-list.txt)
  - [GitHub](https://github.com/ayucat)
- [ipfiles](https://hosts.ipfiles.com/)
  - Good candidate for host checking.
- [sh0rtie](https://hostsfile.mine.nu/)
  - Can append one of the following to this URL: `Hosts.txt` `hosts0.txt`
- [ijustshotyou](https://ijustshotyou.com/hosts.txt)
  - Pwn me a Joomla.
- [Tom Conlin](https://ix.cs.uoregon.edu/~tomc/NotAfanboy-adblock.txt)
  - Guessing this is an old Fanboy list.
- [jasonhill](https://jasonhill.co.uk/pfsense/ad_servers_dnsbl.txt)
  - May be good to go: Cloudflare just doesn't like download utilities.
- [tvtom](jazz.tvtom.pl/download/hosts)
  - Last-Modified: Sun, 23 May 2021 01:01:11 GMT
- [jeffmilner](https://jeffmilner.com/hosts)
  - last-modified: Sat, 06 Jul 2019 16:36:07 GMT
  - Base site is active.
- [landlordhat](https://landlordhat.com/stuff/hosts)
  - [hosts2.txt](https://landlordhat.com/stuff/)
- [mebrowser](http://mebrowser.com/webservices/ads_data/block_list_data.txt)
  - Last-Modified: Sun, 27 Aug 2017 20:01:10 GMT
- [Dirk Salva](http://members.ping.de/~dirk/https_free.txt)
- [meteophysique](http://meteophysique.free.fr/hosts.txt)
  - Last-Modified: Fri, 11 Apr 2014 21:54:52 GMT
- [SpamAssassin](http://mirror.serverloft.eu/wstearns/sa-blacklist/sa-blacklist.current.domains)
  - More info and older lists [here](http://mirror.serverloft.eu/wstearns/sa-blacklist/).
- [mobione](https://mobione.pl/adaway.txt)
- [mozgabyte](http://mozgabyte.narod.ru/files/hosts.txt)
  - Last-Modified: Wed, 02 Mar 2016 14:02:14 GMT
- [nagafix](https://nagafix.co.uk/resources/browsers/hosts.txt)
  - Last-Modified: Tue, 09 Jan 2007 23:07:50 GMT
- [neko](http://neko.kapsi.fi/hosts/neko-hosts-upd.txt)
  - last-modified: Fri, 07 Jul 2017 06:00:13 GMT
- [Parasite Eliminator](http://parasite-eliminator.narod.ru/updates/update.txt)
  - Last-Modified: Mon, 08 Apr 2013 23:51:06 GMT
- egloos attachments
  - [201510/20/97](http://pds25.egloos.com/pds/201510/20/97/Microsoft_Diagnostics_Tracking.txt)
- ynet attachments
  - [11415367](https://prdupl02.ynet.co.il/ForumFiles/11415367.txt)
- [tknr](https://github.com/tknr/adblock-plus-japanese-filter)
- [michaeltrimm](https://github.com/michaeltrimm/hosts-blocking)
- [doug](http://rdruw.net/doug/Geek/SPYWARE/AD-AWARE/SITES.TXT)
- [offense-b-gone](https://github.com/ryancastro/offense-b-gone)
- [bouras](http://s.bouras.free.fr/linux/hosts)
  - Last-Modified: Mon, 18 Apr 2005 17:20:25 GMT
- [shaolinbliter](http://shaolinbliter.free.fr/hosts.txt)
- squarespace attachments
  - [1381778865929](http://static.squarespace.com/static/5123cad2e4b03a5603ce855a/t/525c45b1e4b01707f4b5844c/1381778865929/ads.txt)
  - [1381779186239](http://static.squarespace.com/static/5123cad2e4b03a5603ce855a/t/525c46f2e4b0a70777c20012/1381779186239/malware.txt)
- [Pitrisovy](http://stuff.pitris.info/adblock/)
- [tek00](http://tek00.free.fr/HOSTS.txt)
  - Mirror of the AdzHosts application hosts.
- [tekrider](https://tekrider.net/general/hosts.txt)
- [v1x0r](https://v1x0r.com/downloads/blocklist/)
  - There is recent activity: may be of interest to monitor.
- [watweewoo](http://watweewoo.altervista.org/coding/mixed/hosts.htm)
- [fatboy9175](https://www.angelfire.com/comics2/fatboy9175/)
  - [MShosts](https://www.angelfire.com/comics2/fatboy9175/MShosts.txt)
  - [uthosts](https://www.angelfire.com/comics2/fatboy9175/uthosts.txt)
- [battleit](http://www.battleit.ee/filter2.txt)
- [be4u](http://www.be4u.kr/wp/wp-content/uploads/2010/11/hosts1.txt)
- [Randolph Langley](https://www.cs.fsu.edu/~langley/other.zones)
- [etscdimmo](http://www.etscdimmo.free.fr/cv/hosts)
  - Last-Modified: Thu, 25 Mar 2010 20:08:22 GMT
- [fotozik](https://www.fotozik.fr/wp-content/uploads/2010/02/hosts.txt)
  - Seems to be another AdzHost list.
- [funnyai](https://www.funnyai.com/upload/file/20131208015703.txt)
- [gonewto](http://www.gonewto.com/main.conf)
  - Last-Modified: Mon, 23 Jul 2018 13:24:41 GMT
- [jabcreations](https://www.jabcreations.com/downloads/adblock-filters.php)
- [kn34pc](https://www.kn34pc.com/tmp/)
- [larrygc](http://www.larrygc.com/rip/hosts)
- [Leigh Brasington](http://www.leighb.com/hosts.txt)
- [nsit](https://www.nsit.co.za/files/linux_related/adslist.txt)
  - last-modified: Mon, 06 Apr 2015 08:50:56 GMT
- [veity](https://www.physik.tu-berlin.de/~veity/)
- [r-rill](http://www.r-rill.net/AdBlocker/myRules.txt)
  - Last-Modified: Sat, 15 Mar 2014 12:46:42 GMT
- [songwave](http://www.songwave.com/software/blocklist.txt)
- [stupidmormons](http://www.stupidmormons.com/privacy/Hosts.txt)
  - Last-Modified: Thu, 31 Oct 2002 14:13:44 GMT
- [taiwanmobileservices](http://www.taiwanmobileservices.com/vpn/shadowsocks.conf)
  - Last-Modified: Thu, 22 Aug 2019 07:16:09 GMT
- [tecnopcx](https://tecnopcx.com/Cyber/data.host)
  - last-modified: Wed, 11 Jan 2012 05:13:01 GMT
- [verzijlbergh](https://www.verzijlbergh.com/adblock/nlblock.txt)
- [zawards](http://zawards.net/Files/hosts_Ultimate.txt)
  - Last-Modified: Fri, 17 Apr 2015 11:26:09 GMT
- [zitstif](http://zitstif.no-ip.org)
  - [THENEWLIST](http://zitstif.no-ip.org/THENEWLIST.txt)
    - Last-Modified: Tue, 18 Apr 2017 02:13:20 GMT
  - [Other Lists](http://zitstif.no-ip.org/?cat=1037)
