# Black Mirror

The primary goals of this project are as follows:

- Promote individual safety.
  - Actively promotes [GitHub's non-allowance policies](https://docs.github.com/en/github/site-policy/github-community-guidelines#what-is-not-allowed) at-scale where possible.
- Promote individual privacy.
  - Blacklist all telemetry services, other data harvesting services, and untrusted torrenting providers.
  - Whitelist all services like Tor, VPNs, and trusted torrenting providers.
- Promote individual and corporate security.
  - Blacklist illegal or sketchy sites, known malicious actors, active attackers, malvertising, etc.
- Promote sanity across social forums.
  - Blacklist advertising sources in general, on both desktop and mobile clients.
  - Blacklist general misinformation, irreputable news sources, propaganda, etc.
  - Encourage a more family-friendly environment on the larger internet.
- Use list sources that promote growth, minimal redundancy, and modern application.
- [Acknowledge technological harm, and do what can be done in this scope to prevent it.](https://ledger.humanetech.com/)

`Black Mirror` aims to support reasonable thought exchange by blocking hosts that would discourge or harm it.
While this is censorship inherent to every blacklist, irresponsible censorship is *not* supported by this project.
Because speech freedom is encourged, so too is feedback and constructive criticism.
The real power behind the freedom of speech is the ability to hear many opinions to quickly deduce those that are correct or reasonable.

“Before you become too entranced with gorgeous gadgets and mesmerizing video displays, let me remind you that information is not knowledge, knowledge is not wisdom, and wisdom is not foresight. Each grows out of the other, and we need them all.”\
― *Arthur C. Clarke*

## Table of contents

- [Black Mirror](#black-mirror)
  - [On Spyware/Stalkerware](#on-spywarestalkerware)
  - [On Propaganda](#on-propaganda)
  - [On Social Media](#on-social-media)

## On Spyware/Stalkerware

<p align="center">
<a href="https://www.youtube.com/watch?v=I5WjTTi67BE"><img src="https://res.cloudinary.com/marcomontalbano/image/upload/v1633709643/video_to_markdown/images/youtube--I5WjTTi67BE-c05b58ac6eb4c4700831b2b3070cd403.jpg"
       alt="GitHub Top Languages"
       longdesc="https://raw.githubusercontent.com/anuraghazra/github-readme-stats/master/readme.md"
       crossorigin="anonymous"
       referrerpolicy="no-referrer"
       width="500" /></a>
<a href="https://www.ted.com/talks/eva_galperin_what_you_need_to_know_about_stalkerware/transcript?language=en&utm_campaign=black_mirror&utm_medium=referral&utm_source=github_com_T145/black-mirror"><img src="https://pi.tedcdn.com/r/s3.amazonaws.com/talkstar-photos/uploads/43595f89-1962-4904-8034-ee2d26971f7b/EvaGalperin_2019W-embed.jpg?op=%5E&c=1280%2C720&gravity=t&u%5Br%5D=2&u%5Bs%5D=0.5&u%5Ba%5D=0.8&u%5Bt%5D=0.03&quality=82&w=1280&h=720"
       alt="GitHub Top Languages"
       longdesc="https://raw.githubusercontent.com/anuraghazra/github-readme-stats/master/readme.md"
       crossorigin="anonymous"
       referrerpolicy="no-referrer"
       width="500" /></a>
</p>

These services intrude on privacy, are usually malware, and compromise individual safety. Therefore any known parties are blocked.

“There will come a time when it isn't 'They're spying on me through my phone' anymore. Eventually, it will be 'My phone is spying on me'.”\
― *Philip K. Dick*

## On Propaganda

<p align="center">
<a href="https://www.ted.com/talks/eva_galperin_what_you_need_to_know_about_stalkerware/transcript?language=en&utm_campaign=black_mirror&utm_medium=referral&utm_source=github_com_T145/black-mirror"><img src="https://pi.tedcdn.com/r/s3.amazonaws.com/talkstar-photos/uploads/db5bcc6b-ea54-4c76-a43a-1d0a5b5e5adc/AndrewMarantz_2019-embed.jpg?op=%5E&c=1280%2C720&gravity=t&u%5Br%5D=2&u%5Bs%5D=0.5&u%5Ba%5D=0.8&u%5Bt%5D=0.03&quality=82&w=1280&h=720"
       alt="GitHub Top Languages"
       longdesc="https://raw.githubusercontent.com/anuraghazra/github-readme-stats/master/readme.md"
       crossorigin="anonymous"
       referrerpolicy="no-referrer"
       width="500" /></a>
</p>

Internet "rabbit holes" and sites that primarily feature "knee-jerk contrarianism" do not promote sanity, and therefore are blocked.

Regarding religion and sciences, `Black Mirror` takes an agnostic position on matters regarding how the universe began or where lacking sufficient historical data produces inconclusive results.
This means a source will not be specifically blocked for promoting a popular viewpoint, such as athiesm, a religion, alternative sciences, etc.
However, on matters where sufficient information is available to make an educated conclusion,
"knee-jerk contrarian" views featured on sites as a majority opinion (> 50%)
will result in their host(s) being blocked. To take this same reasoning into a non-religious context
and provide a practical example, because we have conclusive evidence on the fact that the Earth is round
from the time of Eratosthenes, sites that feature contradictory viewpoints as an opinion majority get blocked.

Regarding politics, `Black Mirror` takes a non-radical Libertarian perspective.
A source will not be specifically blocked for promoting a popular viewpoint, such as a non-radical left or right political perspective.
Like dealings with religion, platforms that promote "knee-jerk contrarianism" or philosophy that significantly breaches individual safety as an opinion majority will be blocked.

“True liberty consists only in the power of doing what we ought to will, and in not being constrained to do what we ought not to will.”\
― *Jonathan Edwards*

“Make decency cool again.”\
― *Andrew Marantz*

## On Social Media

### The Zuckerburg Institute of Virology

#### Facebook

Due to consistent privacy and security concerns, this platform will be blocked.

- [The Facebook Files](https://www.wsj.com/articles/the-facebook-files-11631713039)

#### Instagram

Owned by Facebook, but does not have majority support on issues that would get the site blocked. Its trackers and such will be blocked.

#### WhatsApp

Owned and heavily monitored by Facebook. Communications may be private between users, but can still be monitored by Facebook.
It also has a track record of significant security concerns. All services will be blocked.

### Twitter

Though the cause of most internet drama, this platform is also where many cybersecurity community members communicate and collaborate.
While it has compromised privacy and serves personalized ads, the platform itself will remain unblocked to promote cybersecurity communities.
Its trackers and such will be blocked.

### Reddit

While there are some relatively harmful subreddits, they are not in the majority. Many such subreddits have actually been banned, so this will remain unblocked.
Its trackers and such will be blocked.

### Snapchat

Largely supports privacy, even though there are some security concerns. Will remain unblocked.

### Tumblr

After Instagram and Snapchat came up, this platform has become largely marginalized and can typically support insanity under earlier definitions.
Therefore all services will be blocked.

### TikTok

Due its moderation lacking in categories that would classify as not promoting sanity under earlier definitions, it will be blocked.
