<div align="center">
  <img src=".github/images/logo.png"
       width="600"
       alt="logo"
       longdesc="https://github.com/T145/black-mirror/master/README.md" />
  <h3>🌓 Reflection | 💿 Redundancy | ✅ Reliability</h3>
  <hr>
  <p>Aiming to promote security, safety, and sanity across the internet!</p>
  <hr>
  <a href="https://github.com/humanetech-community/awesome-humane-tech#awesome-humane-tech--">
    <img src="https://raw.githubusercontent.com/humanetech-community/awesome-humane-tech/main/humane-tech-badge.svg?sanitize=true"
        alt="humane-tech"
        longdesc="https://raw.githubusercontent.com/humanetech-community/awesome-humane-tech/main/humane-tech-badge.svg"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
  <a href="https://github.com/T145/black-mirror/commits/master.atom">
    <img src="https://img.shields.io/static/v1?logo=rss&label=RSS&message=feed&color=FFA500"
        alt="release"
        longdesc="https://github.com/badges/shields/"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
  <a href="https://bestpractices.coreinfrastructure.org/projects/6372">
    <img src="https://bestpractices.coreinfrastructure.org/projects/6372/badge">
  </a>
</div>
<div align="center">
  <a href="https://github.com/T145/black-mirror">
    <img src="https://img.shields.io/github/repo-size/T145/black-mirror?logo=adblock&style=flat&label=Repo%20Size"
        alt="repo-size"
        longdesc="https://shields.io/"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
  <a href="https://github.com/T145/black-mirror">
    <img src="https://img.shields.io/github/commit-activity/w/T145/black-mirror?logo=adblock&style=flat&label=Commit%20Activity"
        alt="commit-activity"
        longdesc="https://shields.io/"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
  <a href="https://hits.seeyoufarm.com/#history">
    <img src="https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https%3A%2F%2Fgithub.com%2FT145%2Fblack-mirror&count_bg=%2379C83D&title_bg=%23555555&icon=&icon_color=%23E7E7E7&title=Traffic+%28Daily%2FTotal%29&edge_flat=false"
        alt="traffic"
        longdesc="https://hits.seeyoufarm.com"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
</div>
<div align="center">
  <img src="https://img.shields.io/github/actions/workflow/status/T145/black-mirror/publish_lists.yml?branch=master&label=Release&logo=github"
       alt="release"
       longdesc="https://github.com/badges/shields/"
       crossorigin="anonymous"
       referrerpolicy="no-referrer" />
  <a href="https://www.dropbox.com/sh/lg4i0sjexubhcz6/AABO35HOVeK7Z0VHXN9MTp_ya?dl=0">
    <img src="https://img.shields.io/static/v1?logo=dropbox&label=Dropbox&message=builds&color=0061FF"
        alt="release"
        longdesc="https://github.com/badges/shields/"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
  <a href="https://github.com/T145/black-mirror/pkgs/container/black-mirror">
    <img src="https://img.shields.io/github/actions/workflow/status/T145/black-mirror/publish_docker.yml?branch=master&color=%232496ED&label=Docker&logo=docker"
        alt="docker"
        longdesc="https://github.com/badges/shields/"
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
  </a>
</div>

<div align="center">
  <sub>
    <em>Made with 💖 by</em>
  </sub>
</div>

<div align="center">
  <a href="https://github.com/T145" target="_blank">
    <img width=200px height=75px src="https://glitch-image.vercel.app/api?text=T145" />
  </a>
</div>

## 🛡️ Privacy Protectors

> Good causes that help secure your digital life.

- *__[Stop using Cloudflare!](https://framagit.org/dCF/deCloudflare/-/tree/master)__*
- Test your browser's tracking resilience with [CoverYourTracks](https://coveryourtracks.eff.org/)!
- Support [LetsBlockIt](https://letsblock.it/) to consolidate and simplify uBlock filters!
- Explore [PrivacyGuides](https://privacyguides.org/) and [Prism Break](https://prism-break.org/en/all/) to discover services that respect your privacy!
- Use [BypassPaywalls](https://github.com/iamadamdev/bypass-paywalls-chrome#readme) to access restricted and useful information, such as the [WSJ's Facebook Files](https://www.wsj.com/articles/the-facebook-files-11631713039).
- Skip over URL shortener links by using [FastForward](https://github.com/FastForwardTeam/FastForward#readme), which is a better alternative to outright domain blocking.

## 💕 Companion Projects

> Great projects that leverage Black Mirror's content!

</br>
<a href="https://github.com/T145/metalhead"><img src="https://github.com/T145/metalhead/raw/master/.github/images/logo.jpg" width=220px height=60px></a>

<i>NXDOMAIN scanner against Black Mirror's lists</i>
</br>

## 🖋️ [Manifesto](https://github.com/T145/black-mirror/blob/master/MANIFESTO.md)

> Please report any hosts that are wrongly blocked or sources that do not wholly align in an issue.

Defines the logic behind why a host is permitted or blocked.
It has been written to reflect common ideologies across the blacklisting community and those specific to this project.

Complete author bias reflection is not intended, which is why it speaks from the `Black Mirror` person.
Free thought exchange is encouraged, so feel free to open discussions about any points!

## 📋 Attributes

1. Produced in builds specific to each host's syntax.
2. Updates at [1:27 AM UTC](https://www.timeanddate.com/time/zone/timezone/utc).
3. No excess or trailing whitespace.
4. No lingering webscraper garbage.
5. Lines are terminated with `lf`.
6. No blank lines.
7. No comments.

## 🚚 Deliverables

<table>
  <thead>
    <tr>
      <th>List Name</th>
      <th>File Content</th>
      <th>Unique Entries</th>
      <th>File Size</th>
      <th>Mirror 1</th>
      <th>Mirror 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>BLOCK_DOMAIN</td>
      <td>Domain entries</td>
      <td id="BLOCK-DOMAIN-line-count">8,112,236</td>
      <td id="BLOCK-DOMAIN-file-size">179M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/BLOCK_DOMAIN.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/k0cpm86vw66e0jg/BLOCK_DOMAIN.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>BLOCK_IPV4</td>
      <td>IPv4 addresses</td>
      <td id="BLOCK-IPV4-line-count">676,530</td>
      <td id="BLOCK-IPV4-file-size">9.2M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/BLOCK_IPV4.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/zkg2eiypf3d42mj/BLOCK_IPV4.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>BLOCK_IPV6</td>
      <td>IPv6 addresses</td>
      <td id="BLOCK-IPV6-line-count">2,287</td>
      <td id="BLOCK-IPV6-file-size">58K</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/BLOCK_IPV6.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/lun3qt7my8dcj5e/BLOCK_IPV6.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>BLOCK_CIDR4</td>
      <td>IPv4 CIDR blocks</td>
      <td id="BLOCK-CIDR4-line-count">275,183</td>
      <td id="BLOCK-CIDR4-cidr-file-size">1.2M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/BLOCK_CIDR4.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/r0s4balz5b951in/BLOCK_CIDR4.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>ALLOW_DOMAIN</td>
      <td>Domain entries</td>
      <td id="ALLOW-DOMAIN-line-count">666,973</td>
      <td id="ALLOW-DOMAIN-file-size">14M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/ALLOW_DOMAIN.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/xt5frs2ivac14ap/ALLOW_DOMAIN.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>ALLOW_IPV4</td>
      <td>IPv4 addresses</td>
      <td id="ALLOW-IPV4-line-count">83,034</td>
      <td id="ALLOW-IPV4-file-size">1.2M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/ALLOW_IPV4.txt">🔗</a></td>
      <td align="center"><a href="">🔗</a></td>
    </tr>
    <tr>
      <td>ALLOW_IPV6</td>
      <td>IPv6 addresses</td>
      <td id="ALLOW-IPV6-line-count">2,743</td>
      <td id="ALLOW-IPV6-file-size">104K</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/ALLOW_IPV6.txt">🔗</a></td>
      <td align="center"><a href="">🔗</a></td>
    </tr>
    <tr>
      <td>ALLOW_CIDR4</td>
      <td>IPv4 CIDR blocks</td>
      <td id="ALLOW-CIDR4-line-count">7,816</td>
      <td id="ALLOW-CIDR4-file-size">120K</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/ALLOW_CIDR4.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/1esd0w1o2xo6qox/ALLOW_CIDR4.txt?dl=0">🔗</a></td>
    </tr>
    <tr>
      <td>ALLOW_CIDR6</td>
      <td>IPv6 CIDR blocks</td>
      <td id="ALLOW-CIDR6-line-count">137,867</td>
      <td id="ALLOW-CIDR6-file-size">2.2M</td>
      <td align="center"><a href="https://github.com/T145/black-mirror/releases/download/latest/ALLOW_CIDR6.txt">🔗</a></td>
      <td align="center"><a href="https://www.dropbox.com/s/jqstqs2tll0kp84/ALLOW_CIDR6.txt?dl=0">🔗</a></td>
    </tr>
  </tbody>
</table>

### Source Code

- [Tarball](https://api.github.com/repos/T145/black-mirror/tarball/latest)
- [Zipball](https://api.github.com/repos/T145/black-mirror/zipball/latest)

## 🧮 Checksum Evaluation

```bash
sha256sum CHECKSUMS.txt --strict
```

The output will print `OK` if the check was successful. Be sure to run the command in the same directory as the lists!

## 🐙 Fetching GitHub Releases

Provided below are some examples to fetch release artifacts leveraging the GitHub API.

### Get all build artifacts

```bash
curl --proto '=https' --tlsv1.3 -H 'Accept: application/vnd.github.v3+json' -sSf https://api.github.com/repos/T145/black-mirror/releases/latest | jq -r '.assets[].browser_download_url'
```

### Get a build artifact & its checksum

```bash
curl --proto '=https' --tlsv1.3 -H 'Accept: application/vnd.github.v3+json' -sSf https://api.github.com/repos/T145/black-mirror/releases/latest | jq -r '.assets[] | select(.name | startswith("BLOCK_DOMAIN")).browser_download_url'
```

### Get a single build artifact

```bash
curl --proto '=https' --tlsv1.3 -H 'Accept: application/vnd.github.v3+json' -sSf https://api.github.com/repos/T145/black-mirror/releases/latest | jq -r '.assets[] | select(.name | startswith("BLOCK_DOMAIN")) | select(.name | endswith(".txt")).browser_download_url'
```

## 🐋 Docker Usage

To provide a temporary container to experiment with `Black Mirror` scripts and the CLI utilities it uses, run the following:

```bash
docker container run -it --rm -h black-mirror ghcr.io/t145/black-mirror
```

For a persistant container, use something like what's given below:

```bash
docker container run -it --name black-mirror -h black-mirror ghcr.io/t145/black-mirror
```

Then to access the container at a later date, run:

```bash
docker start black-mirror
docker exec -it black-mirror /bin/bash
```

NOTE: Before using `rkhunter`, be sure to run:

```bash
rkhunter --update
```

## 🛠️ List Usage

### Hosts File

```bash
mawk '{print "0.0.0.0 " $0}' BLOCK_DOMAIN.txt >>hosts
# mawk '{print ":: " $0}' BLOCK_DOMAIN.txt >>hosts
mawk '{print "0.0.0.0 " $0}' BLOCK_IPV4.txt >>hosts
mawk '{print ":: " $0}' BLOCK_IPV6.txt >>hosts
```

### [Dnsmasq](https://dnsmasq.org/)

Many popular platforms such as OpenWRT, DDWRT, and Pi-hole use Dnsmasq as their choice TCP powerhouse. After inspecting many domain blocklists you'll inevitably run across a list in the `dnsmasq.conf` format. This list doesn't support it because you can use the `addn-hosts` parameter to add hosts in the list.
Target a file that has the hosts in a format similar to the __Hosts File__ format.

If you're using the `RADVD` daemon, prepend any listed hosts with [`::`](https://stackoverflow.com/questions/40189084/what-is-for-localhost-and-0-0-0-0). Otherwise, even if you have IPv6 support set up, prepend hosts with [`0.0.0.0`](https://github.com/StevenBlack/hosts#we-recommend-using-0000-instead-of-127001).

This has been tested across all the mentioned platforms using `dig{6}` on a small sample size and had each host null-routed successfully. [DNSmasq's man page](https://thekelleys.org.uk/dnsmasq/docs/dnsmasq-man.html) discusses configuration further, and [DDWRT's ad blocking wiki page](https://wiki.dd-wrt.com/wiki/index.php/Ad_blocking) provides some examples.

#### Amazon EC2 DNS Resolver

Follow [this guide](https://aws.amazon.com/premiumsupport/knowledge-center/dns-resolution-failures-ec2-linux/) to create a DNS server on an Amazon EC2 instance.

### [Pi-hole](https://pi-hole.net/)

If you'd like to update when some sources do or not extract a production build, just use the [single-line list](https://discourse.pi-hole.net/t/how-to-add-blocklists-v5-and-later/32127) [`sources.pihole`](https://github.com/T145/black-mirror/blob/master/dist/sources.pihole).
Note that this list only contains Pihole-compatible sources, and not every handled source. Some manual configuration may also be required.

### [unbound](https://nlnetlabs.nl/projects/unbound/about/)

Similar to dnsmasq, but requires more manual configuration. Name any products as a \*.conf file. [Then follow Steffinstanly's instructions on how to apply blocklists](https://medium.com/@steffinstanly/unbound-dns-blocking-3567986a5735).

### [personalDNSfilter](https://github.com/IngoZenz/personaldnsfilter)

Use the domain list.

### [Adguard](https://adguard.com/en/welcome.html)

Leverage the [`sources.adguard`](https://github.com/T145/black-mirror/blob/master/dist/sources.adguard) list or the domain list.

## 👨‍💻 Development

### Workspace Setup

Install Docker, [PNPM](https://pnpm.io/installation), and NodeJS. These can usually be installed with a popular package manager.
The specific Node version used in this project is provided in `.node-version`, but any version over `16` should work.
With Docker running in the background, execute `pnpm lint` to debug any changes.

## 🎉 Special Thanks

### Stargazers

[![Stargazers repo roster for @T145/black-mirror](https://reporoster.com/stars/dark/T145/black-mirror)](https://github.com/T145/black-mirror/stargazers)

### Forkers

[![Forkers repo roster for @T145/black-mirror](https://reporoster.com/forks/dark/T145/black-mirror)](https://github.com/T145/black-mirror/network/members)

## 🎶 Notes

### Need for speed

- <https://fossies.org/linux/parallel/src/parsort>
- <https://unix.stackexchange.com/questions/579251/how-to-use-parallel-to-speed-up-sort-for-big-files-fitting-in-ram#579252>
- <https://askubuntu.com/questions/1006377/check-the-max-allowed-threads-count-for-sure#1006384>
- <https://stackoverflow.com/questions/9066609/fastest-possible-grep>

### Some List References

- <https://www.covert.io/threat-intelligence/>
- <https://filterlists.com/>
- <https://firebog.net/>
- <https://grimore.org/assets/databases/blocklist-ipsets>
- <https://users.cs.northwestern.edu/~jesse/course/cs214-fa19/lec/21-bloom/bloom.txt>
- <https://gist.github.com/jedisct1/c7548d814de2dd661f033d9cb18a0006>

### Lamers Unwelcome

- [cybercrime-tracker](https://atm.cybercrime-tracker.net/index.php)
  - [EMV](https://emv.cybercrime-tracker.net/index.php?x=faq)
- [MalwareBazaar](https://bazaar.abuse.ch/browse/)
- [virusbay](https://beta.virusbay.io/sample/browse)
- [malpedia](https://malpedia.caad.fkie.fraunhofer.de/)
- [manalyzer](https://manalyzer.org/)
- [malshare](https://malshare.com/daily/malshare.current.all.txt)
- [Metasploit CVEs](https://feeds.ecrimelabs.net/data/metasploit-cve)
- [malarchive](https://github.com/raw-data/malarchive)

### Interesting Oddities

- <https://www.chaosreigns.com/>
- <https://vpn.hidemyass.com/vpn-config/>
- <http://www.textfiles.com/programming/>
- <https://www.rhyolite.com//anti-spam/you-might-be.html>

### Big Data Lists

> Typically used by other blacklist projects as whitelists.

| List Name    | URL                                                                                               |
|--------------|---------------------------------------------------------------------------------------------------|
| Alexa        | <https://s3.amazonaws.com/alexa-static/top-1m.csv.zip>                                            |
| Umbrella     | <https://downloads.majestic.com/majestic_million.csv>                                             |
| Statvoo      | <https://statvoo.com/dl/top-1million-sites.csv.zip>                                               |
| OpenPageRank | <https://www.domcop.com/files/top/top10milliondomains.csv.zip>                                    |
| Quantcast    | <https://toplists.net.in.tum.de/archive/quantcast/quantcast-top-sites-2021-06-25_0900_UTC.txt.xz> |
| Tranco list  | <https://tranco-list.eu/>                                                                         |

### IP Block Providers

> Simply provide IP blocks for entire geographic regions.

- [openportstats](http://www.openportstats.com/)
- [ipdeny](https://www.ipdeny.com/ipblocks/)
- [IPverse](http://ipverse.net/)
